function [x_newt,data] = newton_method(objfun,Q,c,A,b,x0)


% save iterate information
data    = [];
data.x0 = x0;
data.x  = [x0]; % iterates
data.d  = []; % search directions



gamma = .5;
eta = 70;

x = x0;
t = 1;

MAXITER_inner = 200;
MAXITER_outer = 10;



% print the header
printIter();
niter = 0;
tic

tic
for k =1:MAXITER_outer  
    f_k = 0.5*x'*Q*x +c'*x;
    

    for j=1:MAXITER_inner % Inner loop

        [barrier_val,g,H] = objective_barrier(t,x,A,b,Q,c);

        d_j = -H\g; % Newton step

        lambda = g'*d_j; % Newton decrement

        % Perform backtracking line search along search direction
        alpha = 1;

        while (min(b - A*(x+alpha*d_j)) < 0)
            alpha = 0.5*alpha;
        end % first get feasible point ... then search minimum

        [barrier_val1,~,~]=objective_barrier(t,x+alpha*d_j,A,b,Q,c);

        while (barrier_val1 > barrier_val + gamma*alpha*lambda)
            alpha = 0.5*alpha;
            [barrier_val1,~,~]=objective_barrier(t,x+alpha*d_j,A,b,Q,c);
        end
        
        x = x+alpha*d_j;
        
    end
    
    printIter(k, f_k, norm(x-data.x(:,k)), toc);
    
    % record the iterates
    if nargout >= 2
        data.x = [data.x,x];
    end

    t = eta*t;

end


x_newt=x;
end

function printIter(iter, f_k, d_k_norm, CPUtime)
% print the iteration progress

if nargin==0
% Store output header and footer strings as persistent variables
out_line = '================================================================================';
out_data = '   k       f     ||x^k - x^{k+1}||        CPU (s)';

% print algorithm output header
fprintf('\nBeginning interior point ...\n')
fprintf('%s\n%s\n%s \n', out_line, out_data, out_line)
return;
end

% Print iterate information
fprintf('% 4d  % .4e  % .4e         % .5f \n',iter, f_k, d_k_norm, CPUtime);

end



